/** XSHELLS diagnostics:
*  record m-spectrum
*/

	static std::vector<double> mspec(MMAX+1);       // backup spectrum
	static int mmax_spec = 11;      // maximum m to record (default 11)
	if ((evol_ubt & EVOL_U) && (MMAX > 0)) {
		// generate labels
		static std::ostringstream labels;
		if (labels.str().length() == 0) {       // generate labels only once.
			if (mp.var.find("mmax_spec") != mp.var.end()) mmax_spec = mp.var["mmax_spec"];	// override mmax_spec from xshells.par
			if (MMAX < mmax_spec) mmax_spec = MMAX;
			for (int m=0; m<=mmax_spec; m++)  labels << "m=" << m << " ";
			labels << "\t";
		}
		if (mmax_spec >= 0) {
			// register diagnostics and labels
			double* diags = all_diags.append(mmax_spec+1, labels.str().c_str());            // append array for MMAX+1 diagnostics
			Ulm.spectrum(0, &mspec[0]);                                 // fill m-spectrum to be summed accross shells and stored in energy file.
			for (int m=0; m<=mmax_spec; m++) diags[m] = mspec[m];       // copy to diags
		}
	}
